varying vec2 texture_coordinate;
uniform sampler2D source;
uniform float radius;
//uniform vec3 mintex;

void main() {
	vec3 accum = vec3(0.0,0.0,0.0);
	vec3 mintex = vec3(0.0,0.0,0.0);
	float d = radius;
	
	if(d == 0.0) {
		gl_FragColor = texture2D(source, texture_coordinate);
	} else {
		float mipbias = 32.0;
		
		// layer 1 (4 samples)
		accum += clamp(texture2D(source, texture_coordinate + vec2(0,0.333333333333333)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;	
		accum += clamp(texture2D(source, texture_coordinate + vec2(0.333333333333333,5.98298838306261e-10)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(1.19659767661252e-09,-0.333333333333333)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(-0.333333333333333,-1.79489644090392e-09)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		// layer 3 (16 samples)
		accum += clamp(texture2D(source, texture_coordinate + vec2(0,1)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(0.382683431950523,0.923879532683006)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(0.707106780551956,0.707106781821139)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(0.923879531996129,0.382683433608791)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(1,1.79489651491878e-09)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(0.923879533369883,-0.382683430292255)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(0.707106783090323,-0.707106779282772)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(0.382683435267059,-0.923879531309252)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(3.58979302983757e-09,-1)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(-0.382683428633986,-0.92387953405676)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(-0.707106778013589,-0.707106784359506)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(-0.923879530622375,-0.382683436925327)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(-1,-5.38468932271175e-09)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(-0.923879534743638,0.382683426975718)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(-0.70710678562869,0.707106776744405)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;
		accum += clamp(texture2D(source, texture_coordinate + vec2(-0.382683438583595,0.923879529935497)*d, d*mipbias).rgb - mintex, 0.0, 100.0) * 1.0 ;	

		gl_FragColor = vec4((accum/20.0),1);// + texture2D(source, texture_coordinate)* 0.25;
	}
}
